/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SvnActionRE {
    public static final String PATH = "path";
    public static final String CONTENTSTATE = "contentState";
    public static final String PROPSTATE = "propState";
    public static final String REVISION = "revision";
    private Pattern pattern;
    private Matcher matcher;
    private int action;
    private int contentStatus = 1;
    private int propStatus = 1;
    private String[] notificationProperties;

    public SvnActionRE(String string, int n, String[] stringArray) {
        this.pattern = Pattern.compile('^' + string + '$');
        this.action = n;
        this.notificationProperties = stringArray;
    }

    public SvnActionRE(String string, int n, String string2) {
        this.pattern = Pattern.compile('^' + string + '$');
        this.action = n;
        this.notificationProperties = new String[]{string2};
    }

    public SvnActionRE(String string, int n) {
        this.pattern = Pattern.compile('^' + string + '$');
        this.action = n;
        this.notificationProperties = new String[0];
    }

    public SvnActionRE(String string, int n, int n2, int n3) {
        this(string, n);
        this.contentStatus = n2;
        this.propStatus = n3;
    }

    public SvnActionRE(String string, int n, int n2, String[] stringArray) {
        this(string, n, stringArray);
        this.contentStatus = n2;
    }

    public SvnActionRE(String string, int n, int n2, int n3, String[] stringArray) {
        this(string, n, stringArray);
        this.contentStatus = n2;
        this.propStatus = n3;
    }

    public int getAction() {
        return this.action;
    }

    private int getIndex(String string) {
        for (int i = 0; i < this.notificationProperties.length; ++i) {
            if (!this.notificationProperties[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean match(String string) {
        this.matcher = this.pattern.matcher(string);
        return this.matcher.matches();
    }

    public String getPath() {
        int n = this.getIndex(PATH);
        if (n == -1) {
            return null;
        }
        return this.matcher.group(n + 1);
    }

    private int getStatus(char c) {
        if (c == ' ') {
            return 2;
        }
        if (c == 'C') {
            return 7;
        }
        if (c == 'G') {
            return 6;
        }
        if (c == 'U') {
            return 5;
        }
        return 1;
    }

    public int getContentState() {
        if (this.contentStatus != 1) {
            return this.contentStatus;
        }
        int n = this.getIndex(CONTENTSTATE);
        if (n == -1) {
            return 1;
        }
        String string = this.matcher.group(n + 1);
        return this.getStatus(string.charAt(0));
    }

    public int getPropStatus() {
        if (this.propStatus != 1) {
            return this.propStatus;
        }
        int n = this.getIndex(PROPSTATE);
        if (n == -1) {
            return 1;
        }
        String string = this.matcher.group(n + 1);
        return this.getStatus(string.charAt(0));
    }

    public long getRevision() {
        int n = this.getIndex(REVISION);
        if (n == -1) {
            return -1L;
        }
        String string = this.matcher.group(n + 1);
        return Long.parseLong(string);
    }
}

